#include <iostream.h>
#include "esp3.h"

void main()
{
  unsigned num_fotoni = 10000, n_colonne = 400;
  Energia e_min = 0.005, delta_e = 0.005;
  double  h_legno=1., h_scint=5.08, r_scint=2.74;
  double A = 0.0697;

  Vett_3 origine(0.0, 0.0, 0.0);
  SorgenteCs sorg(origine);
  Scintillatore scint(h_legno, h_scint, r_scint);
  Istogramma isto(delta_e, n_colonne, A);
    
  unsigned i = 0;
  while(i < num_fotoni)
    {
      Fotone f = sorg.Emetti();
      Energia e_dep;

      if(scint.Impatto(f))
	{
	  e_dep = 0.0;
	  bool processa_fotone = true;
	  while(processa_fotone)
	    {
	      if(!scint.Interagisce(f)) //esce dal while
		break;

	      switch ( scint.Interazione(f, e_dep) )
		{
		case FOTOELETTRICO:
		  processa_fotone = false;
		  break;
		case COMPTON:
		  if(f.GetEnergia() < e_min)
		    processa_fotone = false;
		  break;
		default:
		  //ERRORE
		  cerr << "Errore: Tipo di interazione sconosciuto." << endl;
		  exit(0);
		}
	    }//while(processa_fotone)
	} //if(scint.Impatto(f))
      isto.Inserisci(e_dep);
      
      i++;
    }
  isto.Stampa();
}

