//$Id:2$ (versione, non rimuovere)

#include <stdlib.h>  
#include <math.h>
#include <assert.h>
#include <iostream.h>
#include "esp3_2.h"

//metodi di Random
Random::Random()
{ 
  srand(1101969); 
  seed = 1101969; 
}

Random::Random(unsigned int _seed) 
{ 
  srand(_seed); 
  seed = _seed; 
}

inline double Random::Uniforme()
{
  double res = double(rand()) / double(RAND_MAX);
  
  return res;
}

//algoritmo Box-Mueller
inline double Random::Normale()
{
  double r1 = Uniforme(); 
  double r2 = Uniforme(); 
  double theta = 2.0 * PI * r2;
  
  double g = sqrt( 2.0 * log(1.0 / r1) ) * cos(theta);

  return g;
}


//metodi ed operatori di Vett_3

void Vett_3::Stampa() 
{ cout << "(" << v[0] << '\t' << v[1] << '\t' << v[2] << ")" << endl; }

double Vett_3::Mod()
{
  double ris = sqrt( v[0]*v[0] + v[1]*v[1] + v[2]*v[2] );
  
   return ris;
}

Vett_3 Vett_3::Molt(const Mat_3_3& mat)
{
  Vett_3 ris;
  
  for(int i = 0; i < 3; i++)
    {
      ris.v[i] = 0.0;
      for(int j = 0; j < 3; j++)
	ris.v[i] += mat.m[i][j] * v[i];
    }
  
  return ris;
}

//prodotto scalare
double operator*(const Vett_3& op1, const Vett_3& op2)
{
  double res = op1.v[0]*op2.v[0] + op1.v[1]*op2.v[1] + op1.v[2]*op2.v[2];
  
  return res;
}

Vett_3 operator*(const double op1, const Vett_3& op2)
{
  Vett_3 ris;
  
  for(int i = 0; i < 3; i++)
    ris.v[i] = op1 * op2.v[i];

  return ris;
}

Vett_3 operator+(const Vett_3& op1, const Vett_3& op2)
{
  Vett_3 ris;
  
  for(int i = 0; i < 3; i++)
    ris.v[i] = op1.v[i] + op2.v[i];
  
  return ris;
}

//metodi di Vers_3

Vers_3::Vers_3()
{
  v[0] = 1.0;
  v[1] = 0.0;
  v[2] = 0.0;
}

Vers_3::Vers_3(double x, double y, double z) : Vett_3(x, y, z)
{
  double inv_rad_mod = 1.0/Mod();

  v[0] = inv_rad_mod * v[0];
  v[1] = inv_rad_mod * v[1];
  v[2] = inv_rad_mod * v[2];
}

Vers_3::Vers_3(const Vett_3& v3) : Vett_3(v3) 
{
  double inv_rad_mod = 1.0/Mod();

  v[0] = inv_rad_mod * v[0];
  v[1] = inv_rad_mod * v[1];
  v[2] = inv_rad_mod * v[2];
}
  
Vers_3::Vers_3(double theta, double phi)
{
  v[0] = sin(theta) * cos(phi);
  v[1] = sin(theta) * sin(phi);
  v[2] = cos(theta);
}

double Vers_3::Theta()
{
  return acos(v[2]);
}

double Vers_3::Phi()
{
  return atan(v[1]/v[0]);
}

void Vers_3::Stampa() 
{ cout << "<" << v[0] << '\t' << v[1] << '\t' << v[2] << ">" << endl; }

//metodi di Mat_3_3
Mat_3_3::Mat_3_3(double m00 = 0.0, double m01 = 0.0, double m02 = 0.0, 
		 double m10 = 0.0, double m11 = 0.0, double m12 = 0.0, 
		 double m20 = 0.0, double m21 = 0.0, double m22 = 0.0)
{
  m[0][0] = m00; m[0][1] = m01; m[0][2] = m02;
  m[1][0] = m10; m[1][1] = m11; m[1][2] = m12;
  m[2][0] = m20; m[2][1] = m21; m[2][2] = m22;
}
void Mat_3_3::Stampa()
{
  for(int i = 0; i < 3; i++)
    {
      for(int j = 0; j < 3; j++)
	cout << m[i][j] << '\t';
      
      cout << endl;
    }
}

//metodi di Cilindro
Cilindro::Cilindro(double h,  double a,  double r) 
{ 
  dist_sorg_scint  = h; 
  raggio  = r;
  altezza = a; 
  
  theta_max =  dist_sorg_scint? atan(r/dist_sorg_scint) : PI/2.0;
}


bool Cilindro::Dentro(Vett_3 v)
{
  bool res = (fabs(v.v[0]) < raggio) && (fabs(v.v[1]) < raggio) && 
    (v.v[2] < (dist_sorg_scint + altezza)) && (v.v[2] > dist_sorg_scint);
  
  return res;
}

bool Cilindro::Incide(Vers_3 v)
{
  double theta_v = v.Theta();
  
  if(theta_v < theta_max)
    return true;
  
  return false;
}

//metodi di NaI
//ESERCIZIO: inserire i valori campionati
float NaI::en_mu[NUM_CAMPIONI][3] =
{
};


double NaI::MuCompton(Energia e)
{
  register int i = 0;
  
  while( !( e >= en_mu[i][0] && e < en_mu[i+1][0]) )
    i++;
  
  double mu_compton = en_mu[i][1] + ( (en_mu[i+1][1] - en_mu[i][1]) / (en_mu[i+1][0] - en_mu[i][0]) ) * (e - en_mu[i][0]);
  
  return mu_compton;
}

double NaI::MuFotoelettrico(Energia e)
{
  register int i = 0;

  while( !( e >= en_mu[i][0] && e < en_mu[i+1][0]) )
    i++;
  
  double mu_foto = en_mu[i][2] + ( (en_mu[i+1][2] - en_mu[i][2]) / (en_mu[i+1][0] - en_mu[i][0]) ) * (e - en_mu[i][0]);
  
  return mu_foto;
}


double NaI::Mu(Energia e)
{
  double res = MuCompton(e) + MuFotoelettrico(e);
  
  return res;
}

//Metodi classe Scintillatore
Random Scintillatore::r(6532392);

Scintillatore::Scintillatore(double h,  double a,  double r) : Cilindro(h, a, r) {}

//se il fotone incide viene aggiornata la sua pos. con quella d'impatto
bool Scintillatore::Impatto(Fotone& f)
{
  if( Incide(f.propagazione) )
    {
      //Scintillatore friend di Fotone, aggiorna le coordinate di f con quelle del punto d'impatto
      f.coordinate = f.coordinate + (dist_sorg_scint/cos(f.propagazione.Theta())) * f.propagazione;

      return true;
    }
  
  return false;
}

//estrae un percorso e verifica se  compatibile con una interazione
bool Scintillatore::Interagisce(Fotone& f)
{
  Energia e_gamma = f.GetEnergia();
  
  double d = -( log(1 - r.Uniforme()) / Mu(e_gamma) );
  
  //aggiorna la posizione di possibile interazione del fotone
  f.coordinate = f.coordinate + d * f.propagazione;
 
  if(Dentro(f.coordinate))
    return true;
  
  return false;
}

//sceglie il tipo di interazione, se e` compton aggiorna lo stato del fotone, aggiorna l'energia depositata e quella del fotone
TipoInterazione Scintillatore::Interazione(Fotone& f, Energia& e_dep)
{
  Energia e_in = f.GetEnergia();
  double prob_compton = MuCompton(e_in) / Mu(e_in);
  double p = r.Uniforme();
  
  if(p > prob_compton)
    {
      //Caso Interazione Fotoelettrica
      //ESERCIZIO: implementare 
      //...
      return FOTOELETTRICO;
    }
  else
    {
      //Caso Interazione Compton
      //ESERCIZIO: implementare

      return COMPTON;
    }
  
}
	

//Metodi classe Fotone
Fotone::Fotone(Energia e, Vett_3 coord, Vers_3 prop)
{
  energia = e;
  coordinate = coord;
  propagazione = prop;
}

void Fotone::Stampa()
{
  cout << "Energia: " << energia << endl;
  coordinate.Stampa();
  propagazione.Stampa();
}

//Metodi classe Sorgente e derivate
Random Sorgente::r;

Vers_3 Sorgente::EmissioneIsotropa()
{
  double theta = r.Uniforme() * PI;
  double phi   = r.Uniforme() * 2.0 * PI;
  
  Vers_3 res(theta, phi);

  return res;
}

SorgenteNa::SorgenteNa(Vett_3 ps) : Sorgente(ps) {}

Fotone SorgenteNa::Emetti()
{
  Energia e_source;
  
  Vers_3 propagazione = EmissioneIsotropa();
  
  if(r.Uniforme() < 0.7)
    e_source = 0.511;
  else
    e_source = 1.27;
  
  Fotone res(e_source, p, propagazione);
  
  return res;
}

SorgenteCs::SorgenteCs(Vett_3 ps) : Sorgente(ps) {}

Fotone SorgenteCs::Emetti()
{
  Energia e_source = 0.662;
  
  Vers_3 propagazione = EmissioneIsotropa();
  
  Fotone res(e_source, p, propagazione);
  
  return res;
}

SorgenteCo::SorgenteCo(Vett_3 ps) : Sorgente(ps) {}

Fotone SorgenteCo::Emetti()
{
  //ESERCIZIO
}
  
//Metodi classe Istogramma
Random Istogramma::r(1545375);
Istogramma::Istogramma(Energia _delta, unsigned _colonne, double _A)
{
  assert(_colonne >= 1);
  assert(_delta > 0);
  
  v = (unsigned long*) calloc(sizeof(unsigned long), _colonne);

  delta = _delta;
  colonne = _colonne;
  A = _A;
  min = delta;
  max = delta * colonne;
}

//ritorna il valore inserito(errore gaussiano aggiunto)
unsigned long Istogramma::Inserisci(Energia e)
{
  unsigned indice;
  Energia e_mis;
  
  if(e != 0.0)
    e_mis = e + A * r.Normale() * sqrt(e);
  else
    e_mis = 0.0;
  
  if(e_mis < min)
    indice = 0;
  else if(e_mis > max)
    indice = colonne-1;
  else
    indice = unsigned( (e_mis / max) * (colonne-1) + 1);
  
  v[indice]++;

  return indice;
}
  
void Istogramma::Stampa(ostream &os = cout)
{
  for(unsigned i = 0; i < colonne; i++)
    os << dec << i << "\t" << v[i] << endl;
}
  
