//$Id:2$ (versione, non rimuovere)

const double PI   = 3.1415926535897932384626433832795029;
const double mec2 = 0.511; //si puo' fare di meglio!

const unsigned NUM_CAMPIONI = 35; //Ridefinire col numero di campioni delle mu

typedef double Energia;

enum TipoInterazione {COMPTON, FOTOELETTRICO};

class Random
{
  unsigned int seed;
public:
  Random();
  Random(unsigned int _seed);
  inline double Uniforme();
  inline double Normale();
};

class Mat_3_3; //forward declarations
class Cilindro;

//realizza un vettore 3D
class Vett_3
{
protected:
  double v[3];
  
public:
  Vett_3(double x = 0.0, double y = 0.0, double z = 0.0)
  { v[0] = x; v[1] = y; v[2] = z; }
  virtual void Stampa();
  double Mod();
  Vett_3 Molt(const Mat_3_3& );
  //overload dell'operatore somma
  // parte dell'interfaccia, anche se non  un metodo
  friend double operator*(const Vett_3&, const Vett_3&);
  friend Vett_3 operator*(const double, const Vett_3&);
  friend Vett_3 operator+(const Vett_3& , const Vett_3&);
  //friend bool Cilindro::Dentro(Vett_3 v);
  friend class Cilindro;

};

//specializza il vettore 3D al concetto di versore
class Vers_3 : public Vett_3
{
 public:
  //crea un versore
  Vers_3();
  Vers_3(double x, double y, double v);
  //converte in Vett_3 in un Vers_3
  Vers_3(const Vett_3& v3);
  //crea un versore da coordinate sferiche
  Vers_3(double theta, double phi);
  double Theta();
  double Phi();
  //lo sto ridefinendo rispetto alla classe base
  void Stampa();
};

//realizza una matrice 3x3
class Mat_3_3
{
  double m[3][3];
public:
  Mat_3_3(double m00 = 0.0, double m01 = 0.0, double m02 = 0.0, 
	  double m10 = 0.0, double m11 = 0.0, double m12 = 0.0, 
	  double m20 = 0.0, double m21 = 0.0, double m22 = 0.0);
  void Stampa(); 
  // parte dell'interfaccia, anche se non  un metodo di Mat_3_3
  friend Vett_3 Vett_3::Molt(const Mat_3_3& m);
};




//geometria come in figura 
//(sorgente sul prolungamento dell'asse del cilindro, sull'asse z)
class Cilindro
{
protected:
  double dist_sorg_scint; //distanza rivelatore sorgente
  double raggio;
  double altezza;
  
  double theta_max; //massimo angolo azimutale dei fotoni incidenti
  
public:
  Cilindro(double h,  double a,  double r);  
  bool Dentro(Vett_3 v);
  bool Incide(Vers_3 v);  
};

class NaI
{
  //NUM_CAMPIONI elementi: {energia, compton, fotoelettrico}
  static float en_mu[NUM_CAMPIONI][3];

public:
  double MuFotoelettrico(Energia e);
  double MuCompton(Energia e);
  double Mu(Energia e);
};

class Fotone; //forward decl
    
class Scintillatore : public Cilindro, public NaI
{
  static Random r;

public:
  Scintillatore(double h,  double a,  double r);
  bool Impatto(Fotone& f);//se il fotone incide viene aggiornata la sua pos. con quella d'impatto
  bool Interagisce(Fotone& f);////se il fotone interagisce viene aggiornata la sua posizione
  TipoInterazione Interazione(Fotone& f, Energia& e_dep); //sceglie il tipo di interazione, aggiorna lo stato del fotone e l'energia depositata
};

class Fotone
{
  Energia energia;
  Vett_3  coordinate;
  Vers_3  propagazione;

public:
  Fotone(Energia e, Vett_3 coord, Vers_3 prop);
  Energia GetEnergia() {return energia;} 
  void Stampa();
  friend class Scintillatore;
};

//classe di base astratta (ha un metodo pure-virtual)
//non si possono creare oggetti di questa classe!
class Sorgente
{
protected:
  static Random r;
  Vett_3 p;
public:
  Sorgente(Vett_3 ps) {p = ps;}
  Vers_3 EmissioneIsotropa();
  virtual Fotone Emetti() = 0; 
};

class SorgenteNa : public Sorgente
{
public:
  SorgenteNa(Vett_3 ps);
  Fotone Emetti();
};

class SorgenteCs : public Sorgente
{
public:
  SorgenteCs(Vett_3 ps);
  Fotone Emetti();
};

class SorgenteCo : public Sorgente
{
public:
  SorgenteCo(Vett_3 ps);
  Fotone Emetti();
};

class Istogramma
{
  static Random r;

  unsigned long* v;
  Energia delta;
  unsigned colonne;
  double A;
  Energia min;
  Energia max;
 public:
  
  Istogramma(Energia _delta, unsigned colonne, double A);

  unsigned long Inserisci(Energia val); //ritorna la colonna che  stata incrementata
  void Stampa(ostream &os = cout);
};

