//$Id:2$ (versione, non rimuovere)

#include <iostream.h>
#include <fstream.h>
#include "esp3_2.h"

void main()
{
  unsigned num_fotoni = 100000, n_colonne = 100;
  Energia e_min = 0.01, delta_e = 0.01;
  double  h_legno=1., h_scint=5.08, r_scint=2.74;
  double A = 0.01; //inserire il valore misurato sperimentalmente
  ofstream datafile;
  const char* datafile_name = "nai.out";
  
  //apro il file per la stampa dell'istogramma
  datafile.open(datafile_name);


  Vett_3 origine(0.0, 0.0, 0.0);
  SorgenteCs sorg(origine);
  Scintillatore scint(h_legno, h_scint, r_scint);
  Istogramma isto(delta_e, n_colonne, A);
    
  unsigned i = 0;
  while(i < num_fotoni)
    {
      Fotone f = sorg.Emetti();
      Energia e_dep;

      if(scint.Impatto(f))
	{
	  e_dep = 0.0;
	  bool processa_fotone = true;
	  bool interagito = false;
	  while(processa_fotone)
	    {
	      if(!scint.Interagisce(f)) //esce dal while
		break;

	      interagito = true;
	      
	      switch ( scint.Interazione(f, e_dep) )
		{
		case FOTOELETTRICO:
		  processa_fotone = false;
		  break;
		case COMPTON:
		  if(f.GetEnergia() < e_min)
		    processa_fotone = false;
		  break;
		default:
		  //ERRORE
		  cerr << "Errore: Tipo di interazione sconosciuto." << endl;
		  exit(1);
		}
	    }//while(processa_fotone)
	  //inserisce e_dep nell'istogramma solo se il fotone ha interagito
	  if(interagito)
	    isto.Inserisci(e_dep);
	} //if(scint.Impatto(f))
      
      i++;
    }
  isto.Stampa(datafile);
  datafile.close();
}

